<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\Referral;
use App\Models\User;
use App\Models\Autoclaim;
use App\Models\AutoclaimsHistory;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'faucetpay_acc',
        'expresscrypto_acc',
        'energy',
        'points',
        'blocked',
        'last_bonus',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    function referredBy() {
        return $this->hasMany(Referral::class, 'referred_by');
    }

    public function history()
    {
        return $this->hasManyThrough(AutoclaimsHistory::class, Autoclaim::class);
    }
}
